/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.dao.manager;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.cache.GlueCacheLoader;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.dao.manager.GlueQueryDefinition;
import com.poscoict.glueframework.schema.parser.GlueQueryMapInfo;
import com.poscoict.glueframework.schema.parser.GlueQueryParser;
import com.poscoict.glueframework.util.GlueFileResourceUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.springframework.beans.factory.InitializingBean;

public class GlueQueryLoader
implements GlueCacheLoader,
InitializingBean {
    private static final String b = ".glue_sql";
    private final Logger c = LoggerFactory.getLogger(this.getClass());
    private String d = "query";
    private String e = "UTF-8";
    private List<String> f = null;
    private List<String> g = null;
    private Map<Object, String> h = null;
    private boolean i = false;
    @Deprecated
    protected static final String a = "queryMap";

    @Override
    public Object loadCacheObject(Object object, String string) throws GlueException {
        if ("_sql-region".equals(object)) {
            this.h = new HashMap<Object, String>();
            HashMap<String, GlueQueryDefinition> hashMap = new HashMap<String, GlueQueryDefinition>();
            this.c.info("Loading query file(s) from class path {}", (Object)this.f.toString());
            for (String string2 : this.f) {
                Map<String, GlueQueryDefinition> map = null;
                try {
                    URL uRL = GlueFileResourceUtil.getResource(string2);
                    Object object2 = GlueQueryParser.getInstance().parseXml(uRL);
                    this.c.trace("{} file has {} queries. {}", new Object[]{string2, object2.getQueryMap().size(), object2.getQueryMap().keySet()});
                    map = this.a((GlueQueryMapInfo)object2);
                }
                catch (Exception exception) {
                    this.c.error("Fail to load query file: " + string2, (Throwable)exception);
                }
                if (map == null || map.isEmpty()) continue;
                for (Object object2 : map.keySet()) {
                    this.h.put(object2, string2);
                }
                hashMap.putAll(map);
            }
            return hashMap;
        }
        if (this.h != null && this.h.containsKey(object)) {
            try {
                URL uRL = GlueFileResourceUtil.getResource(this.h.get(object));
                GlueQueryMapInfo glueQueryMapInfo = GlueQueryParser.getInstance().parseXml(uRL);
                return this.a(glueQueryMapInfo);
            }
            catch (Exception exception) {
                this.c.error("Fail to load '" + object + "' from " + this.h.get(object), (Throwable)exception);
            }
        }
        return null;
    }

    private Map<String, GlueQueryDefinition> a(GlueQueryMapInfo glueQueryMapInfo) {
        HashMap<String, GlueQueryDefinition> hashMap = new HashMap<String, GlueQueryDefinition>();
        for (Map.Entry entry : glueQueryMapInfo.getQueryMap().entrySet()) {
            hashMap.put((String)entry.getKey(), this.a((GlueQueryMapInfo.GlueQueryInfo)entry.getValue()));
        }
        return hashMap;
    }

    private GlueQueryDefinition a(GlueQueryMapInfo.GlueQueryInfo glueQueryInfo) {
        String string = glueQueryInfo.getId();
        String string2 = glueQueryInfo.getSql();
        boolean bl = glueQueryInfo.isNamed();
        String string3 = glueQueryInfo.getResultType();
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition(string, string2, bl);
        if (string3 != null && string3.length() > 0) {
            glueQueryDefinition.setMappedClassName(string3.trim());
        }
        if (this.i) {
            String string4 = glueQueryInfo.getDesc();
            if (string4 != null && string4.length() > 0) {
                glueQueryDefinition.setDescription(string4.trim());
            } else {
                glueQueryDefinition.setDescription("");
            }
        }
        return glueQueryDefinition;
    }

    private List<VirtualFile> a(VirtualFile virtualFile) {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        if (virtualFile.isDirectory()) {
            List list = virtualFile.getChildren();
            for (VirtualFile virtualFile2 : list) {
                if (virtualFile2.isFile()) {
                    arrayList.add(virtualFile2);
                    continue;
                }
                arrayList.addAll(this.a(virtualFile2));
            }
        } else {
            arrayList.add(virtualFile);
        }
        return arrayList;
    }

    public void setRootPath(String string) {
        String string2 = GlueStaticContext.getGlueProperty(string);
        this.d = string2 != null && string2.length() > 0 ? string2.replace('\\', '/') : string.replace('\\', '/');
    }

    public void setExtraQueryFiles(List<String> list) {
        this.g = list;
    }

    public void setLoadDesc(boolean bl) {
        this.i = bl;
    }

    public void setPathEncoding(String string) {
        this.e = string;
    }

    public String getRootPath() {
        return this.d;
    }

    public void afterPropertiesSet() throws Exception {
        Object object;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(this.d);
        if (uRL == null) {
            object = this.d.replaceAll("\\\\", "/");
            uRL = Thread.currentThread().getContextClassLoader().getResource((String)object);
        }
        this.f = new ArrayList<String>();
        if (this.g != null) {
            this.f.addAll(this.g);
        }
        if (uRL != null) {
            this.c.info("{}' url : {}", (Object)this.d, (Object)uRL);
            if ("file".equals(uRL.getProtocol())) {
                object = new File(uRL.toURI());
                this.c.trace("isDirectory : {}", (Object)((File)object).isDirectory());
                this.c.trace("canRead : {}", (Object)((File)object).canRead());
                this.c.trace("isFile : {}", (Object)((File)object).isFile());
                this.c.trace("listFiles : {}", ((File)object).isDirectory() ? Integer.valueOf(((File)object).listFiles().length) : "-");
                if (object != null && ((File)object).isDirectory()) {
                    List<File> list = GlueFileResourceUtil.getListOfFiles((File)object);
                    for (File file : list) {
                        String string = file.toURI().getPath();
                        if (!string.endsWith(b)) continue;
                        this.c.trace("{} - {}", (Object)uRL.getProtocol(), (Object)string);
                        this.f.add(string.substring(string.indexOf(this.d)));
                    }
                }
            } else if ("vfs".equals(uRL.getProtocol())) {
                object = this.a(VFS.getChild((URI)uRL.toURI()));
                Iterator<VirtualFile> iterator = object.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile = iterator.next();
                    String string = virtualFile.getPathName();
                    if (!string.endsWith(b)) continue;
                    this.c.trace("{} - {}", (Object)uRL.getProtocol(), (Object)string);
                    this.f.add(string.substring(string.indexOf(this.d)));
                }
            } else if ("jar".equals(uRL.getProtocol()) || "zip".equals(uRL.getProtocol())) {
                int n;
                object = uRL.getPath();
                if (object != null && ((String)object).startsWith("file:")) {
                    object = ((String)object).substring("file:".length());
                }
                if ((n = ((String)(object = URLDecoder.decode((String)object, this.e))).indexOf("!")) < 0) {
                    this.c.error("{}", (Object)uRL.getPath());
                }
                String string = ((String)object).substring(0, n);
                Enumeration<JarEntry> enumeration = new JarFile(new File(string)).entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string2 = jarEntry.getName();
                    if (!string2.endsWith(b) || !string2.contains(this.d)) continue;
                    this.c.trace("{} - {}", (Object)uRL.getProtocol(), (Object)jarEntry);
                    if (string2.indexOf(this.d) == string2.lastIndexOf(this.d)) {
                        n = string2.indexOf(this.d);
                    } else {
                        int n2 = string2.lastIndexOf(this.d);
                        n = string2.substring(0, n2).lastIndexOf(this.d);
                    }
                    this.f.add(string2.substring(n));
                }
            } else {
                this.c.error(MarkerFactory.getMarker((String)"FATAL"), "change log configuration. trace level, please");
                this.c.error(MarkerFactory.getMarker((String)"FATAL"), "not support. send log, please");
            }
        }
    }
}

