/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.cache.remote;

import com.poscoict.glueframework.bean.GlueBeanFactoryImpl;
import com.poscoict.glueframework.cache.GlueCacheException;
import com.poscoict.glueframework.cache.GlueCacheManager;
import com.poscoict.glueframework.cache.remote.GlueCacheEvent;
import com.poscoict.glueframework.context.GlueStaticContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueCacheEventProcessor {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private final GlueCacheManager[] b;

    public GlueCacheEventProcessor() throws GlueCacheException {
        GlueBeanFactoryImpl glueBeanFactoryImpl = (GlueBeanFactoryImpl)GlueStaticContext.getBeanFactory();
        String[] stringArray = glueBeanFactoryImpl.getWrappedBeanFactory().getBeanNamesForType(GlueCacheManager.class);
        int n = stringArray.length;
        if (n == 0) {
            throw new GlueCacheException("Cannot find CacheManager bean in context xml file");
        }
        this.b = new GlueCacheManager[n];
        for (int i = 0; i < n; ++i) {
            this.b[i] = glueBeanFactoryImpl.getBeanObject(stringArray[i], GlueCacheManager.class);
            this.a.info("Cache Manager is registered (bean name:{}, class:{})", (Object)stringArray[i], (Object)this.b[i].getClass().getName());
        }
    }

    public String processCacheEvent(GlueCacheEvent glueCacheEvent) {
        this.a.info("Requested cache event:{}", (Object)glueCacheEvent);
        int n = this.b.length;
        for (int i = 0; i < n; ++i) {
            this.b[i].removeCacheObject(glueCacheEvent.getCacheKey(), glueCacheEvent.getRegionName());
        }
        return "successfully processed";
    }
}

