/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.cache.ehcache;

import com.poscoict.glueframework.cache.GlueCacheException;
import com.poscoict.glueframework.cache.GlueCacheLoader;
import com.poscoict.glueframework.cache.GlueCacheManager;
import java.io.InputStream;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class GlueEhCacheManager
implements GlueCacheManager,
DisposableBean,
InitializingBean {
    protected final Logger a = LoggerFactory.getLogger(this.getClass());
    private Resource b;
    private CacheManager c;

    public Resource getLocation() {
        return this.b;
    }

    public void setLocation(Resource resource) {
        this.b = resource;
    }

    @Override
    public Object getCacheObject(Object object) {
        return this.getCacheObject(object, "_default-region");
    }

    @Override
    public Object getCacheObject(Object object, String string) {
        return this.getCacheObject(object, string, null, Object.class);
    }

    @Override
    public <T> T getCacheObject(Object object, Class<T> clazz) {
        return this.getCacheObject(object, "_default-region", clazz);
    }

    @Override
    public <T> T getCacheObject(Object object, String string, Class<T> clazz) {
        return this.getCacheObject(object, string, null, clazz);
    }

    @Override
    public <T> T getCacheObject(Object object, String string, GlueCacheLoader glueCacheLoader, Class<T> clazz) {
        Object v;
        Object object2 = this.getCacheObject(object, string, glueCacheLoader);
        if (object2 != null && clazz.isAssignableFrom(object2.getClass())) {
            return (T)object2;
        }
        if (object2 != null && object2 instanceof Map && (v = ((Map)object2).get(object)) != null && clazz.isAssignableFrom(v.getClass())) {
            return (T)v;
        }
        return null;
    }

    @Override
    public Object getCacheObject(Object object, String string, GlueCacheLoader glueCacheLoader) {
        Cache cache = this.c.getCache(string);
        if (cache != null) {
            Element element = cache.get(object);
            if (element != null) {
                return element.getObjectValue();
            }
            if (glueCacheLoader != null) {
                element = new Element(object, glueCacheLoader.loadCacheObject(object, string));
                cache.put(element);
                return element.getObjectValue();
            }
        } else {
            this.a.debug("not defined cache name : {}", (Object)string);
            throw new GlueCacheException(string);
        }
        return null;
    }

    @Override
    public void putCacheObject(Object object, Object object2) {
        this.putCacheObject(object, object2, "_default-region");
    }

    @Override
    public void putCacheObject(Object object, Object object2, String string) {
        Cache cache = this.c.getCache(string);
        if (cache == null) {
            this.a.debug("not defined cache name : {}", (Object)string);
            throw new GlueCacheException(string);
        }
        Element element = new Element(object, object2);
        cache.put(element);
    }

    @Override
    public boolean isPresent(Object object) {
        return this.isPresent(object, "_default-region");
    }

    @Override
    public boolean isPresent(Object object, String string) {
        Cache cache = this.c.getCache(string);
        return cache != null && cache.get(object) != null;
    }

    @Override
    public void removeCacheObject(Object object) {
        this.removeCacheObject(object, "_default-region");
    }

    @Override
    public void removeCacheObject(Object object, String string) {
        Cache cache = this.c.getCache(string);
        if (cache == null) {
            this.a.debug("not defined cache name : {}", (Object)string);
            throw new GlueCacheException(string);
        }
        cache.remove(object);
    }

    @Override
    public void clear() {
        this.clear("_default-region");
    }

    @Override
    public void clear(String string) {
        Cache cache = this.c.getCache(string);
        if (cache == null) {
            this.a.debug("not defined cache name : {}", (Object)string);
            throw new GlueCacheException(string);
        }
        cache.removeAll();
    }

    public void afterPropertiesSet() throws Exception {
        this.a.info("create EhCache CacheManger");
        if (this.b != null) {
            this.c = CacheManager.create((InputStream)this.b.getInputStream());
            this.a.info("Configuring ehcache from {}", (Object)this.b);
        } else {
            this.c = CacheManager.create();
        }
        this.a.info("start EhCache CacheManger : {}", (Object)this.c.getName());
        if (this.a.isDebugEnabled()) {
            this.a.debug("{}", (Object)this.c.getConfiguration().getCacheConfigurationsKeySet());
        }
    }

    public void destroy() throws Exception {
        this.a.info("shutdown EhCache CacheManger");
        this.c.shutdown();
    }
}

