/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.biz.control;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.biz.control.GlueService;
import com.poscoict.glueframework.cache.GlueCacheLoader;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.schema.parser.GlueServiceInfo;
import com.poscoict.glueframework.schema.parser.GlueServiceParser;
import com.poscoict.glueframework.util.GlueFileResourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.springframework.beans.factory.InitializingBean;

public class GlueServiceLoader
implements GlueCacheLoader,
InitializingBean {
    private static final String a = "-service.xml";
    private final Logger b = LoggerFactory.getLogger(this.getClass());
    private String c = "service";
    private List<String> d = null;
    private String e = "UTF-8";
    private Map<String, String> f = null;

    public String getRootPath() {
        return this.c;
    }

    public void setRootPath(String string) {
        String string2 = GlueStaticContext.getGlueProperty(string);
        this.c = string2 != null && string2.length() > 0 ? string2.replace('\\', '/') : string.replace('\\', '/');
        this.c = string;
    }

    public void setExtraServiceFiles(List<String> list) {
        this.d = list;
    }

    private List<VirtualFile> a(VirtualFile virtualFile) {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        if (virtualFile.isDirectory()) {
            List list = virtualFile.getChildren();
            for (VirtualFile virtualFile2 : list) {
                if (virtualFile2.isFile()) {
                    arrayList.add(virtualFile2);
                    continue;
                }
                arrayList.addAll(this.a(virtualFile2));
            }
        } else {
            arrayList.add(virtualFile);
        }
        return arrayList;
    }

    private String a(String string) {
        int n = string.lastIndexOf("/") + 1;
        int n2 = string.lastIndexOf(".");
        return string.substring(n, n2);
    }

    private Map<String, String> a() throws URISyntaxException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(this.c);
        if (uRL != null) {
            if ("file".equals(uRL.getProtocol())) {
                File file = new File(uRL.toURI());
                this.b.trace("isDirectory : {}", (Object)file.isDirectory());
                this.b.trace("canRead : {}", (Object)file.canRead());
                this.b.trace("isFile : {}", (Object)file.isFile());
                this.b.trace("listFiles : {}", file.isDirectory() ? Integer.valueOf(file.listFiles().length) : "-");
                if (file != null && file.isDirectory()) {
                    List<File> list = GlueFileResourceUtil.getListOfFiles(file);
                    for (File file2 : list) {
                        String string = file2.toURI().getPath();
                        if (!string.endsWith(a)) continue;
                        this.b.trace("{} - {}", (Object)uRL.getProtocol(), (Object)string);
                        hashMap.put(this.a(string), string);
                    }
                }
            } else if ("vfs".equals(uRL.getProtocol())) {
                List<VirtualFile> list = this.a(VFS.getChild((URI)uRL.toURI()));
                for (VirtualFile virtualFile : list) {
                    String string = virtualFile.getPathName();
                    if (!string.endsWith(a)) continue;
                    this.b.trace("{} - {}", (Object)uRL.getProtocol(), (Object)string);
                    hashMap.put(this.a(string), string);
                }
            } else if ("jar".equals(uRL.getProtocol()) || "zip".equals(uRL.getProtocol())) {
                int n;
                String string = uRL.getPath();
                if (string != null && string.startsWith("file:")) {
                    string = string.substring("file:".length());
                }
                if ((n = (string = URLDecoder.decode(string, this.e)).indexOf("!")) < 0) {
                    this.b.error("{}", (Object)uRL.getPath());
                }
                String string2 = string.substring(0, n);
                Enumeration<JarEntry> enumeration = new JarFile(new File(string2)).entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string3 = jarEntry.getName();
                    if (!string3.endsWith(a) || !string3.contains(this.c)) continue;
                    this.b.trace("{} - {}", (Object)uRL.getProtocol(), (Object)jarEntry);
                    if (string3.indexOf(this.c) == string3.lastIndexOf(this.c)) {
                        n = string3.indexOf(this.c);
                    } else {
                        int n2 = string3.lastIndexOf(this.c);
                        n = string3.substring(0, n2).lastIndexOf(this.c);
                    }
                    hashMap.put(this.a(string3), string3);
                }
            } else {
                this.b.error(MarkerFactory.getMarker((String)"FATAL"), "change log configuration. trace level, please");
                this.b.error(MarkerFactory.getMarker((String)"FATAL"), "not support. send log, please");
            }
        }
        return hashMap;
    }

    @Override
    public Object loadCacheObject(Object object, String string) throws GlueException {
        if ("_service-region".equals(object)) {
            Map<String, String> map = null;
            try {
                map = this.a();
                if (this.f != null) {
                    map.putAll(this.f);
                }
            }
            catch (Throwable throwable) {
                this.b.error(MarkerFactory.getMarker((String)"FATAL"), "Fail to load all service definitions", throwable);
            }
            return map.keySet();
        }
        GlueServiceInfo glueServiceInfo = null;
        try {
            URL uRL = null;
            uRL = this.f != null && this.f.containsKey(object) ? GlueFileResourceUtil.getResource(this.f.get(object)) : GlueFileResourceUtil.getResource(this.c + File.separator + object + ".xml");
            this.b.debug("Loading service file : {}", (Object)uRL.toURI());
            glueServiceInfo = GlueServiceParser.getInstance().parseXml(uRL);
        }
        catch (Exception exception) {
            throw new GlueException(exception.getMessage(), exception);
        }
        if (glueServiceInfo.getName().equals(object)) {
            return new GlueService(glueServiceInfo);
        }
        throw new GlueException("ServiceName in XML File [" + glueServiceInfo.getName() + "] and Service Name[" + object + "] is different ");
    }

    public void afterPropertiesSet() throws Exception {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(this.c);
        if (uRL == null) {
            String string = this.c.replaceAll("\\\\", "/");
            uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            if (uRL != null) {
                this.c = string;
            }
        }
        this.b.info("{}' url : {}", (Object)this.c, (Object)uRL);
        if (this.d != null) {
            this.f = new HashMap<String, String>();
            for (String string : this.d) {
                this.f.put(this.a(string), string);
            }
        }
    }
}

