/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.biz.control;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.biz.control.GlueService;
import com.poscoict.glueframework.cache.GlueCacheLoader;
import com.poscoict.glueframework.dao.manager.GlueQueryManager;
import com.poscoict.glueframework.schema.parser.GlueServiceInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class GlueServiceDBLoader
implements GlueCacheLoader,
InitializingBean {
    private Map<String, String> a = null;
    private Map<String, String> b = null;
    private DataSource c;
    private GlueQueryManager d;
    private final Logger e = LoggerFactory.getLogger(this.getClass());

    public void setDataSource(DataSource dataSource) {
        this.c = dataSource;
    }

    public void setQueryManager(GlueQueryManager glueQueryManager) {
        this.d = glueQueryManager;
    }

    public void setQueryInfoMap(Map<String, String> map) {
        this.b = map;
    }

    @Override
    public Object loadCacheObject(Object object, String string) throws GlueException {
        if ("_service-region".equals(object)) {
            return this.a();
        }
        return this.a((String)object);
    }

    private GlueService a(String string) {
        GlueService glueService;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        GlueServiceInfo glueServiceInfo = null;
        boolean bl = this.e.isDebugEnabled();
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.c);
            if (bl) {
                this.e.trace("Param : {}", (Object)string);
            }
            preparedStatement = connection.prepareStatement(this.a.get("serviceInfo"));
            preparedStatement.setObject(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                if (bl) {
                    this.e.trace("Result : {}", (Object)resultSet.getString("INITIAL_ACTIVITY"));
                }
            } else {
                throw new GlueException("fail to load service - " + string);
            }
            glueServiceInfo = new GlueServiceInfo(string, resultSet.getString("INITIAL_ACTIVITY"));
            JdbcUtils.closeResultSet((ResultSet)resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            preparedStatement = connection.prepareStatement(this.a.get("transactionManagerInfo"));
            preparedStatement.setObject(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (bl) {
                    this.e.trace("Result : {}={}", (Object)resultSet.getString("TX_NAME"), (Object)resultSet.getString("TX_VAL"));
                }
                glueServiceInfo.putTransaction(resultSet.getString("TX_NAME"), Boolean.parseBoolean(resultSet.getString("TX_VAL")));
            }
            JdbcUtils.closeResultSet((ResultSet)resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            preparedStatement = connection.prepareStatement(this.a.get("activityList"));
            preparedStatement.setObject(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                glueServiceInfo.addActivityInfo(resultSet.getString("ACTIVITY_NAME"), resultSet.getString("ACTIVITY_CLASS"));
                if (bl) {
                    this.e.trace("Result : {}'s class is {}", (Object)resultSet.getString("ACTIVITY_NAME"), (Object)resultSet.getString("ACTIVITY_CLASS"));
                }
                if (bl) {
                    this.e.trace("Param : {} {}", (Object)string, (Object)resultSet.getString("ACTIVITY_NAME"));
                }
                preparedStatement2 = connection.prepareStatement(this.a.get("transitionInfo"));
                preparedStatement2.setObject(1, string);
                preparedStatement2.setObject(2, resultSet.getString("ACTIVITY_NAME"));
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    glueServiceInfo.putActivityTransition(resultSet.getString("ACTIVITY_NAME"), resultSet2.getString("TRANSITION_NAME"), resultSet2.getString("TRANSITION_VAL"));
                    if (!bl) continue;
                    this.e.trace("Result {}'s flow : {}->{}", new Object[]{resultSet.getString("ACTIVITY_NAME"), resultSet2.getString("TRANSITION_NAME"), resultSet2.getString("TRANSITION_VAL")});
                }
                JdbcUtils.closeResultSet((ResultSet)resultSet2);
                JdbcUtils.closeStatement((Statement)preparedStatement2);
                preparedStatement2 = connection.prepareStatement(this.a.get("propertyInfo"));
                preparedStatement2.setObject(1, string);
                preparedStatement2.setObject(2, resultSet.getString("ACTIVITY_NAME"));
                resultSet2 = preparedStatement2.executeQuery();
                while (resultSet2.next()) {
                    glueServiceInfo.putActivityTransition(resultSet.getString("ACTIVITY_NAME"), resultSet2.getString("PROPERTY_NAME"), resultSet2.getString("PROPERTY_VAL"));
                    if (!bl) continue;
                    this.e.trace("Result {}'s prroperty, {}:{}", new Object[]{resultSet.getString("ACTIVITY_NAME"), resultSet2.getString("PROPERTY_NAME"), resultSet2.getString("PROPERTY_VAL")});
                }
                JdbcUtils.closeResultSet((ResultSet)resultSet2);
                JdbcUtils.closeStatement((Statement)preparedStatement2);
            }
            JdbcUtils.closeResultSet((ResultSet)resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            glueService = new GlueService(glueServiceInfo);
        }
        catch (Exception exception) {
            try {
                throw new GlueException(exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(preparedStatement);
                JdbcUtils.closeResultSet(resultSet2);
                JdbcUtils.closeStatement(preparedStatement2);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)preparedStatement);
        JdbcUtils.closeResultSet(resultSet2);
        JdbcUtils.closeStatement(preparedStatement2);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        return glueService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> a() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.c);
            preparedStatement = connection.prepareStatement(this.a.get("serviceList"));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("SERVICE_NAME"));
            }
        }
        catch (SQLException sQLException) {
            try {
                this.e.error("fail to get all ServiceName", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(preparedStatement);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)preparedStatement);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        return hashSet;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.c, (String)"DataSource must be provided");
        if (this.d == null) {
            this.a = new HashMap<String, String>();
            this.a.put("serviceList", "select SERVICE_NAME from SERVICE_INFO");
            this.a.put("serviceInfo", "select INITIAL_ACTIVITY from SERVICE_INFO where SERVICE_NAME=?");
            this.a.put("transactionManagerInfo", "select TX_NAME, TX_VAL from SERVICE_TX_MAPPING where SERVICE_NAME=?");
            this.a.put("activityList", "select ACTIVITY_NAME, ACTIVITY_CLASS from SERVICE_ACTIVITY_INFO where SERVICE_NAME=?");
            this.a.put("transitionInfo", "select TRANSITION_NAME, TRANSITION_VAL from SERVICE_ACTIVITY_FLOW where SERVICE_NAME=? and ACTIVITY_NAME=?");
            this.a.put("propertyInfo", "select PROPERTY_NAME, PROPERTY_VAL from SERVICE_ACTIVITY_PROPERTY where SERVICE_NAME=? and ACTIVITY_NAME=?");
        } else if (this.b == null) {
            this.a = new HashMap<String, String>();
            this.a.put("serviceList", this.d.getQueryDefinition(this.b.get("serviceList")).getQueryStatement());
            this.a.put("serviceInfo", this.d.getQueryDefinition(this.b.get("serviceInfo")).getQueryStatement());
            this.a.put("transactionManagerInfo", this.d.getQueryDefinition(this.b.get("transactionManagerInfo")).getQueryStatement());
            this.a.put("activityList", this.d.getQueryDefinition(this.b.get("activityList")).getQueryStatement());
            this.a.put("transitionInfo", this.d.getQueryDefinition(this.b.get("transitionInfo")).getQueryStatement());
            this.a.put("propertyInfo", this.d.getQueryDefinition(this.b.get("propertyInfo")).getQueryStatement());
        } else {
            this.a = new HashMap<String, String>();
            this.a.put("serviceList", this.d.getQueryDefinition("serviceList").getQueryStatement());
            this.a.put("serviceInfo", this.d.getQueryDefinition("serviceInfo").getQueryStatement());
            this.a.put("transactionManagerInfo", this.d.getQueryDefinition("transactionManagerInfo").getQueryStatement());
            this.a.put("activityList", this.d.getQueryDefinition("activityList").getQueryStatement());
            this.a.put("transitionInfo", this.d.getQueryDefinition("transitionInfo").getQueryStatement());
            this.a.put("propertyInfo", this.d.getQueryDefinition("propertyInfo").getQueryStatement());
        }
        this.e.trace("{}", this.a);
    }
}

