/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.ucube4;

import com.poscoict.eai.adapter.handler.IEAIServiceBrokerHandler;
import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.ucube4.GlueUCubeManager;
import com.poscoict.glueframework.ucube4.GlueUCubeSBHCreator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.PriorityOrdered;

public class GlueUCubeManagerImpl
implements GlueUCubeManager,
DisposableBean,
InitializingBean,
PriorityOrdered {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private ScheduledExecutorService b = Executors.newSingleThreadScheduledExecutor();
    private String c = null;
    private List<String> d = null;
    private int e = 0;

    public void setPropertyFileName(String string) {
        this.c = string;
    }

    public void setServiceBrokerNames(List<String> list) {
        this.d = list;
    }

    public void setPeriod(int n) {
        this.e = n;
    }

    public void destroy() throws Exception {
        GlueUCubeSBHCreator.stop();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.c == null) {
            throw new GlueException("Plz specify 'propertyFileName' in applicationContext.xml");
        }
        GlueUCubeSBHCreator.initialize(this.c);
        IEAIServiceBrokerHandler iEAIServiceBrokerHandler = GlueUCubeSBHCreator.getInstance();
        if (iEAIServiceBrokerHandler != null) {
            try {
                boolean bl = true;
                for (String string : this.d) {
                    this.a.info("try starting ServiceBroker=[{}]", (Object)string);
                    boolean bl2 = iEAIServiceBrokerHandler.startServiceBroker(string);
                    bl &= bl2;
                }
                if (!bl && this.e != 0) {
                    ServiceBrokerChecker serviceBrokerChecker = new ServiceBrokerChecker(this.d);
                    this.b.scheduleAtFixedRate(serviceBrokerChecker, 1000L, this.e, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception exception) {
                this.a.error("Failed to start ServiceBroker", (Throwable)exception);
            }
        } else {
            this.a.debug("created useless bean : {}", this.getClass());
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private boolean a(IEAIServiceBrokerHandler iEAIServiceBrokerHandler, String string) {
        if (iEAIServiceBrokerHandler == null) {
            this.a.warn("not initialized - EAIServiceBrokerHandler");
            return false;
        }
        if (!iEAIServiceBrokerHandler.isStartServiceBroker(string)) {
            this.a.warn("not started ServiceBroker - {}", (Object)string);
            return false;
        }
        return true;
    }

    @Override
    public int sendMessage(String string, String string2, String string3) {
        int n = -1;
        IEAIServiceBrokerHandler iEAIServiceBrokerHandler = GlueUCubeSBHCreator.getInstance();
        if (this.a(iEAIServiceBrokerHandler, string)) {
            try {
                n = iEAIServiceBrokerHandler.sendMessage(string, string2, string3, false);
            }
            catch (Exception exception) {
                throw new GlueException("fail to send message", (Throwable)exception);
            }
        }
        return n;
    }

    @Override
    public int[] sendMessages(String string, String string2, List<String> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        IEAIServiceBrokerHandler iEAIServiceBrokerHandler = GlueUCubeSBHCreator.getInstance();
        if (this.a(iEAIServiceBrokerHandler, string)) {
            try {
                int n = 0;
                for (String string3 : list) {
                    nArray[n] = iEAIServiceBrokerHandler.sendMessage(string, string2, string3, true);
                    ++n;
                }
                iEAIServiceBrokerHandler.commit(string);
            }
            catch (Exception exception) {
                iEAIServiceBrokerHandler.rollback(string);
                throw new GlueException("fail to send message", (Throwable)exception);
            }
        }
        return nArray;
    }

    @Override
    public int sendFile(String string, String string2, String string3) {
        IEAIServiceBrokerHandler iEAIServiceBrokerHandler = GlueUCubeSBHCreator.getInstance();
        if (this.a(iEAIServiceBrokerHandler, string)) {
            try {
                return iEAIServiceBrokerHandler.sendFile(string, string2, string3);
            }
            catch (Exception exception) {
                throw new GlueException("fail to send file", (Throwable)exception);
            }
        }
        return -1;
    }

    class ServiceBrokerChecker
    implements Runnable {
        private List<String> b = null;
        private final Logger c = LoggerFactory.getLogger(this.getClass());

        ServiceBrokerChecker(List<String> list) {
            this.b = list;
        }

        @Override
        public void run() {
            IEAIServiceBrokerHandler iEAIServiceBrokerHandler = GlueUCubeSBHCreator.getInstance();
            try {
                int n = 0;
                for (String string : this.b) {
                    if (!iEAIServiceBrokerHandler.isStartServiceBroker(string)) {
                        this.c.info("retry starting ServiceBroker=[{}]", (Object)string);
                        iEAIServiceBrokerHandler.startServiceBroker(string);
                        continue;
                    }
                    ++n;
                }
                if (this.b.size() == n) {
                    GlueUCubeManagerImpl.this.b.shutdown();
                }
            }
            catch (Exception exception) {
                this.c.error("Failed to start ServiceBroker", (Throwable)exception);
            }
        }
    }
}

