/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.util;

import com.poscoict.glueframework.GlueException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TypeCastingUtil {
    protected static final Logger a = LoggerFactory.getLogger(TypeCastingUtil.class);

    public static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof BigDecimal) {
            return "" + ((BigDecimal)object).longValue();
        }
        if (object instanceof Timestamp) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            return simpleDateFormat.format(new Date(((Timestamp)object).getTime()));
        }
        return object.toString();
    }

    public static BigDecimal toBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return "".equals(object) ? null : new BigDecimal((String)object);
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        try {
            return new BigDecimal(object.toString());
        }
        catch (Throwable throwable) {
            a.error("not supported." + object, throwable);
            return null;
        }
    }

    public static Timestamp toTimestamp(Object object, String string) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof String) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                Date date = simpleDateFormat.parse((String)object);
                return new Timestamp(date.getTime());
            }
            if (object instanceof Date) {
                return new Timestamp(((Date)object).getTime());
            }
        }
        catch (Exception exception) {
            a.error("not supported." + object, (Throwable)exception);
        }
        return null;
    }

    public static Timestamp toTimestamp(Object object) {
        if (object instanceof String) {
            return TypeCastingUtil.toTimestamp(object, "yyyy-MM-dd hh:mm:ss");
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        throw new GlueException("not supported." + object);
    }

    public static Long toLong(Object object) {
        if (object instanceof String) {
            return Long.valueOf((String)object);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        String string = "Unsupported Type : " + object;
        a.error(string);
        throw new GlueException(string);
    }

    public static Object getParamValue(Map<?, ?> map, String string, Field field) {
        Object obj = map.get(string);
        Object object = null;
        Object object2 = obj instanceof Object[] ? ((Object[])obj)[0] : obj;
        Class<?> clazz = field.getType();
        if (clazz == null || object2 == null) {
            a.warn("{} is skipped : type is {} or value is {}", new Object[]{string, clazz, object2});
            return null;
        }
        if (clazz == String.class) {
            object = object2.toString();
        } else if (clazz == BigDecimal.class) {
            object = TypeCastingUtil.toBigDecimal(object2);
        } else if (clazz == Timestamp.class) {
            object = TypeCastingUtil.toTimestamp(object2);
        } else if (clazz == Long.class || clazz.getName().equals("long")) {
            object = TypeCastingUtil.toLong(object2);
        } else {
            a.warn("Unsupported Type : {}", clazz);
            object = object2;
        }
        a.debug("{} : {} - {}", new Object[]{string, object, object2});
        return object;
    }

    public static Object getParamValue(Map<?, ?> map, String string, String string2) {
        Object obj = map.get(string);
        Object object = null;
        Object object2 = obj instanceof Object[] ? ((Object[])obj)[0] : obj;
        if (string2 == null || object2 == null) {
            a.warn("{} is skipped : type is {} or value is {}", new Object[]{string, string2, object2});
            return null;
        }
        if (string2.startsWith("String")) {
            object = object2.toString();
        } else if (string2.startsWith("BigDecimal")) {
            object = TypeCastingUtil.toBigDecimal(object2);
        } else if (string2.startsWith("Timestamp")) {
            object = TypeCastingUtil.toTimestamp(object2);
        } else if (string2.startsWith("Long")) {
            object = TypeCastingUtil.toLong(object2);
        } else {
            a.warn("Unsupported Type : {}", (Object)string2);
            object = object2;
        }
        a.debug("{} : {} - {}", new Object[]{string, object, object2});
        return object;
    }
}

