/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.transaction;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.transaction.GlueDefaultTransactionDefinition;
import com.poscoict.glueframework.transaction.GlueTransactionManager;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class GlueHibernateTransactionManager
extends HibernateTransactionManager
implements GlueTransactionManager {
    private static final long serialVersionUID = -6492387472625996994L;
    private final Logger a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TransactionDefinition b;
    private final ThreadLocal<TransactionStatus> c = new ThreadLocal();

    public GlueHibernateTransactionManager() {
        this.b = new GlueDefaultTransactionDefinition();
    }

    public GlueHibernateTransactionManager(SessionFactory sessionFactory) {
        this();
        super.setSessionFactory(sessionFactory);
    }

    protected TransactionStatus a() {
        return this.c.get();
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.b = transactionDefinition;
        this.a.info("[{}] transaction definition is re-configured -> {}" + transactionDefinition.getName(), (Object)transactionDefinition.toString());
    }

    public void startTransaction() throws GlueException {
        TransactionStatus transactionStatus = this.a();
        if (transactionStatus == null) {
            transactionStatus = super.getTransaction(this.b);
            this.c.set(transactionStatus);
            this.a.info("Transaction for Hibernate Start");
        } else {
            this.a.warn("------------------------------------------");
            this.a.warn("Already transaction was started!!");
            this.a.warn("Do not invoke 'startTransaction' twice!!");
            this.a.warn("------------------------------------------");
        }
    }

    public boolean commit() throws GlueException {
        try {
            TransactionStatus transactionStatus = this.a();
            if (transactionStatus == null) {
                this.a.warn("Transaction Status is empty. Commit operation is aborted");
                boolean bl = false;
                return bl;
            }
            super.commit(transactionStatus);
            this.a.info("Commit Complete");
        }
        catch (TransactionException transactionException) {
            this.a.info("fail to Commit");
            throw new GlueException(transactionException.getMessage(), (Throwable)transactionException);
        }
        finally {
            this.c.remove();
            this.a.info("Transaction Status is cleared");
        }
        return true;
    }

    public boolean rollback() throws GlueException {
        try {
            TransactionStatus transactionStatus = this.a();
            if (transactionStatus == null) {
                this.a.warn("Transaction Status is empty. Rollback operation is aborted");
                boolean bl = false;
                return bl;
            }
            super.rollback(transactionStatus);
            this.a.info("Rollback Complete");
        }
        catch (TransactionException transactionException) {
            this.a.info("fail to Rollback");
            throw new GlueException(transactionException.getMessage(), (Throwable)transactionException);
        }
        finally {
            this.c.remove();
            this.a.info("Transaction Status is cleared");
        }
        return true;
    }

    public TransactionStatus changeTransaction(TransactionStatus transactionStatus) throws GlueException {
        TransactionStatus transactionStatus2 = this.a();
        this.c.remove();
        try {
            if (transactionStatus == null) {
                this.a.info("tring to create new Transaction");
                this.startTransaction();
            } else {
                if (transactionStatus2 != null && !transactionStatus2.isCompleted()) {
                    this.a.warn("previous transaction is not completed...");
                }
                this.c.set(transactionStatus);
                this.a.info("TransactionStatus in ThreadLocal is changed: input transaction");
            }
        }
        catch (TransactionException transactionException) {
            throw new GlueException(transactionException.getMessage(), (Throwable)transactionException);
        }
        return transactionStatus2;
    }
}

