/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.mina.common.BroadcastIoSession;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionConfigImpl;
import org.apache.mina.util.Queue;

class DatagramSessionImpl
extends BaseIoSession
implements BroadcastIoSession {
    private final IoService wrapperManager;
    private final IoServiceConfig serviceConfig;
    private final DatagramSessionConfig config = new SessionConfigImpl();
    private final DatagramService managerDelegate;
    private final DatagramFilterChain filterChain;
    private final DatagramChannel ch;
    private final Queue writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress localAddress;
    private final SocketAddress serviceAddress;
    private SocketAddress remoteAddress;
    private SelectionKey key;
    private int readBufferSize;

    DatagramSessionImpl(IoService wrapperManager, DatagramService managerDelegate, IoServiceConfig serviceConfig, DatagramChannel ch, IoHandler defaultHandler, SocketAddress serviceAddress, SocketAddress localAddress) {
        this.wrapperManager = wrapperManager;
        this.managerDelegate = managerDelegate;
        this.filterChain = new DatagramFilterChain(this);
        this.ch = ch;
        this.writeRequestQueue = new Queue();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.serviceAddress = serviceAddress;
        this.localAddress = localAddress;
        this.serviceConfig = serviceConfig;
        IoSessionConfig sessionConfig = serviceConfig.getSessionConfig();
        if (sessionConfig instanceof DatagramSessionConfig) {
            DatagramSessionConfig cfg = (DatagramSessionConfig)sessionConfig;
            this.config.setBroadcast(cfg.isBroadcast());
            this.config.setReceiveBufferSize(cfg.getReceiveBufferSize());
            this.config.setReuseAddress(cfg.isReuseAddress());
            this.config.setSendBufferSize(cfg.getSendBufferSize());
            if (this.config.getTrafficClass() != cfg.getTrafficClass()) {
                this.config.setTrafficClass(cfg.getTrafficClass());
            }
        }
    }

    public IoService getService() {
        return this.wrapperManager;
    }

    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public IoSessionConfig getConfig() {
        return this.config;
    }

    DatagramService getManagerDelegate() {
        return this.managerDelegate;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    DatagramChannel getChannel() {
        return this.ch;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    protected void close0() {
        IoServiceConfig config = this.getServiceConfig();
        if (config instanceof DatagramServiceConfig) {
            ((DatagramServiceConfig)config).getSessionRecycler().remove(this);
        }
        this.filterChain.fireFilterClose(this);
    }

    Queue getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    public TransportType getTransportType() {
        return TransportType.DATAGRAM;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    protected void updateTrafficMask() {
        this.managerDelegate.updateTrafficMask(this);
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    private class SessionConfigImpl
    extends DatagramSessionConfigImpl
    implements DatagramSessionConfig {
        private SessionConfigImpl() {
        }

        public int getReceiveBufferSize() {
            try {
                return DatagramSessionImpl.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setReceiveBufferSize(int receiveBufferSize) {
            if (DatagramSessionConfigImpl.isSetReceiveBufferSizeAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setReceiveBufferSize(receiveBufferSize);
                    receiveBufferSize = DatagramSessionImpl.this.ch.socket().getReceiveBufferSize();
                    DatagramSessionImpl.this.readBufferSize = receiveBufferSize;
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }

        public boolean isBroadcast() {
            try {
                return DatagramSessionImpl.this.ch.socket().getBroadcast();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setBroadcast(boolean broadcast) {
            try {
                DatagramSessionImpl.this.ch.socket().setBroadcast(broadcast);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public int getSendBufferSize() {
            try {
                return DatagramSessionImpl.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setSendBufferSize(int sendBufferSize) {
            if (DatagramSessionConfigImpl.isSetSendBufferSizeAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setSendBufferSize(sendBufferSize);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }

        public boolean isReuseAddress() {
            try {
                return DatagramSessionImpl.this.ch.socket().getReuseAddress();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setReuseAddress(boolean reuseAddress) {
            try {
                DatagramSessionImpl.this.ch.socket().setReuseAddress(reuseAddress);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public int getTrafficClass() {
            if (DatagramSessionConfigImpl.isGetTrafficClassAvailable()) {
                try {
                    return DatagramSessionImpl.this.ch.socket().getTrafficClass();
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
            return 0;
        }

        public void setTrafficClass(int trafficClass) {
            if (DatagramSessionConfigImpl.isSetTrafficClassAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setTrafficClass(trafficClass);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
    }
}

