/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.support.BaseIoAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfigImpl;

public class SocketAcceptorConfig
extends BaseIoAcceptorConfig {
    private SocketSessionConfig sessionConfig = new SocketSessionConfigImpl();
    private int backlog = 50;
    private boolean reuseAddress;

    public SocketAcceptorConfig() {
        ServerSocket s = null;
        try {
            s = new ServerSocket();
            this.reuseAddress = s.getReuseAddress();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to get the default configuration.", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        this.sessionConfig.setReuseAddress(true);
    }

    public IoSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

