/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.executor;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorFilter
extends IoFilterAdapter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Executor executor;
    static /* synthetic */ Class class$org$apache$mina$filter$executor$ExecutorFilter$SessionBuffer;

    public ExecutorFilter() {
        this((Executor)new ThreadPoolExecutor(16, 16, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue()));
    }

    public ExecutorFilter(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(IoFilter.NextFilter nextFilter, IoSession session, EventType type, Object data) {
        Event event = new Event(type, nextFilter, data);
        SessionBuffer buf = SessionBuffer.getSessionBuffer(session);
        List list = buf.eventQueue;
        synchronized (list) {
            buf.eventQueue.add(event);
            if (buf.processingCompleted) {
                buf.processingCompleted = false;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Launching thread for " + session.getRemoteAddress());
                }
                this.executor.execute((Runnable)new ProcessEventsRunnable(buf));
            }
        }
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        nextFilter.sessionCreated(session);
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.OPENED, null);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.CLOSED, null);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        this.fireEvent(nextFilter, session, EventType.IDLE, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        this.fireEvent(nextFilter, session, EventType.EXCEPTION, cause);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        ByteBufferUtil.acquireIfPossible(message);
        this.fireEvent(nextFilter, session, EventType.RECEIVED, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        ByteBufferUtil.acquireIfPossible(message);
        this.fireEvent(nextFilter, session, EventType.SENT, message);
    }

    protected void processEvent(IoFilter.NextFilter nextFilter, IoSession session, EventType type, Object data) {
        if (type == EventType.RECEIVED) {
            nextFilter.messageReceived(session, data);
            ByteBufferUtil.releaseIfPossible(data);
        } else if (type == EventType.SENT) {
            nextFilter.messageSent(session, data);
            ByteBufferUtil.releaseIfPossible(data);
        } else if (type == EventType.EXCEPTION) {
            nextFilter.exceptionCaught(session, (Throwable)data);
        } else if (type == EventType.IDLE) {
            nextFilter.sessionIdle(session, (IdleStatus)data);
        } else if (type == EventType.OPENED) {
            nextFilter.sessionOpened(session);
        } else if (type == EventType.CLOSED) {
            nextFilter.sessionClosed(session);
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) {
        nextFilter.filterWrite(session, writeRequest);
    }

    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        nextFilter.filterClose(session);
    }

    private class ProcessEventsRunnable
    implements Runnable {
        private final SessionBuffer buffer;

        ProcessEventsRunnable(SessionBuffer buffer) {
            this.buffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Event event;
                List list = this.buffer.eventQueue;
                synchronized (list) {
                    if (this.buffer.eventQueue.isEmpty()) {
                        this.buffer.processingCompleted = true;
                        break;
                    }
                    event = (Event)this.buffer.eventQueue.remove(0);
                }
                ExecutorFilter.this.processEvent(event.getNextFilter(), this.buffer.session, event.getType(), event.getData());
            }
            if (ExecutorFilter.this.logger.isDebugEnabled()) {
                ExecutorFilter.this.logger.debug("Exiting since queue is empty for " + this.buffer.session.getRemoteAddress());
            }
        }
    }

    protected static class Event {
        private final EventType type;
        private final IoFilter.NextFilter nextFilter;
        private final Object data;

        Event(EventType type, IoFilter.NextFilter nextFilter, Object data) {
            this.type = type;
            this.nextFilter = nextFilter;
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public EventType getType() {
            return this.type;
        }
    }

    protected static class EventType {
        public static final EventType OPENED = new EventType("OPENED");
        public static final EventType CLOSED = new EventType("CLOSED");
        public static final EventType READ = new EventType("READ");
        public static final EventType WRITTEN = new EventType("WRITTEN");
        public static final EventType RECEIVED = new EventType("RECEIVED");
        public static final EventType SENT = new EventType("SENT");
        public static final EventType IDLE = new EventType("IDLE");
        public static final EventType EXCEPTION = new EventType("EXCEPTION");
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class SessionBuffer {
        private static final String KEY = (class$org$apache$mina$filter$executor$ExecutorFilter$SessionBuffer == null ? (class$org$apache$mina$filter$executor$ExecutorFilter$SessionBuffer = ExecutorFilter.class$("org.apache.mina.filter.executor.ExecutorFilter$SessionBuffer")) : class$org$apache$mina$filter$executor$ExecutorFilter$SessionBuffer).getName() + ".KEY";
        private final IoSession session;
        private final List eventQueue = new ArrayList();
        private boolean processingCompleted = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static SessionBuffer getSessionBuffer(IoSession session) {
            IoSession ioSession = session;
            synchronized (ioSession) {
                SessionBuffer buf = (SessionBuffer)session.getAttribute(KEY);
                if (buf == null) {
                    buf = new SessionBuffer(session);
                    session.setAttribute(KEY, buf);
                }
                return buf;
            }
        }

        private SessionBuffer(IoSession session) {
            this.session = session;
        }
    }
}

